/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.channel;

import com.af.v4.system.common.core.exception.LogicException;
import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.common.plugins.core.ConvertTools;
import com.af.v4.system.common.socket.SocketServerManager;
import com.af.v4.system.common.socket.config.SocketConfigItem;
import com.af.v4.system.common.socket.core.channel.ChannelData;
import com.af.v4.system.common.socket.core.client.ClientManager;
import com.af.v4.system.common.socket.enums.MsgTypeEnum;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChannelHandler<T>
extends SimpleChannelInboundHandler<T> {
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractChannelHandler.class);

    protected abstract void channelRead0(ChannelHandlerContext var1, T var2);

    protected Object runBusiness(ByteBuf content, String remoteAddress) {
        String realData;
        SocketConfigItem configItem = ClientManager.getConfig();
        byte[] data = new byte[content.readableBytes()];
        content.readBytes(data);
        this.LOGGER.info("\u6570\u636e\u539f\u59cb\u4f53\uff1a{}", (Object)Arrays.toString(data));
        try {
            realData = switch (configItem.getDecodeType()) {
                default -> ConvertTools.bytesToStr((byte[])data);
                case MsgTypeEnum.HEX -> ConvertTools.byteToHexStr((byte[])data);
            };
        }
        catch (Exception e) {
            this.LOGGER.error("\u6570\u636e\u89e3\u6790\u5931\u8d25\uff1a", (Throwable)e);
            return null;
        }
        JSONObject params = new JSONObject();
        params.put("value", (Object)realData);
        params.put("address", (Object)remoteAddress);
        try {
            return ((LogicService)SpringUtils.getBean(LogicService.class)).run(configItem.getLogicName(), params);
        }
        catch (Exception e) {
            if (e instanceof LogicException) {
                LogicException ex = (LogicException)e;
                this.LOGGER.error("\u8bf7\u6c42\u6765\u6e90'{}',\u53d1\u751f\u4e1a\u52a1\u5f02\u5e38.\n{}", (Object)remoteAddress, (Object)ex.getStack());
            } else {
                this.LOGGER.error("\u8bf7\u6c42\u6765\u6e90'{}',\u53d1\u751f\u670d\u52a1\u7aef\u5f02\u5e38.", (Object)remoteAddress, (Object)e);
            }
            throw e;
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        String channelId = ctx.channel().id().asLongText();
        this.LOGGER.info("\u6210\u529f\u5efa\u7acb\u8fde\u63a5,channelId\uff1a{}", (Object)channelId);
        String port = String.valueOf(((InetSocketAddress)ctx.channel().localAddress()).getPort());
        SocketConfigItem configItem = SocketServerManager.getSocketConfigItemByPort(port);
        ClientManager.add(new ChannelData(configItem, ctx.channel(), new JSONObject()));
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            ClientManager.remove();
            ctx.close();
        }
        catch (Exception e) {
            this.LOGGER.error("\u5173\u95ed\u901a\u9053\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        super.channelInactive(ctx);
    }
}

