package com.af.v4.system.common.socket.core.server.udp;

import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.liuli.utils.enums.OSTypeEnum;
import com.af.v4.system.common.socket.core.channel.impl.DatagramPacketChannelHandler;
import com.af.v4.system.common.socket.core.server.SocketServer;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;

import javax.annotation.PreDestroy;

/**
 * UDP服务端
 */
public class UdpServer extends SocketServer<Bootstrap, Channel> {
    private EventLoopGroup group;

    @Override
    protected AbstractBootstrap<Bootstrap, Channel> initBootstrap() {
        Class<? extends DatagramChannel> channelClass;
        if (ApplicationUtils.getOSType() == OSTypeEnum.LINUX) {
            group = new EpollEventLoopGroup();
            channelClass = EpollDatagramChannel.class;
        } else {
            group = new NioEventLoopGroup();
            channelClass = NioDatagramChannel.class;
        }
        return new Bootstrap()
                .group(group)
                .channel(channelClass)
                // 配置 编码器、解码器、业务处理
                .handler(new ChannelInitializer<DatagramChannel>() {
                    @Override
                    protected void initChannel(DatagramChannel ch) {
                        ch.pipeline().addLast(new DatagramPacketChannelHandler());
                    }
                });
    }

    /**
     * 销毁
     */
    @PreDestroy
    public void destroy() {
        group.shutdownGracefully();
    }
}
