package com.af.v4.system.common.socket.core.server.tcp;

import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.liuli.utils.enums.OSTypeEnum;
import com.af.v4.system.common.socket.core.channel.impl.ByteBufChannelHandler;
import com.af.v4.system.common.socket.core.server.SocketServer;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;

import javax.annotation.PreDestroy;

/**
 * TCP服务端
 */
public class TcpServer extends SocketServer<ServerBootstrap, ServerChannel> {
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    @Override
    protected AbstractBootstrap<ServerBootstrap, ServerChannel> initBootstrap() {
        Class<? extends ServerSocketChannel> channelClass;
        if (ApplicationUtils.getOSType() == OSTypeEnum.LINUX) {
            bossGroup = new EpollEventLoopGroup();
            workerGroup = new EpollEventLoopGroup();
            channelClass = EpollServerSocketChannel.class;
        } else {
            bossGroup = new NioEventLoopGroup();
            workerGroup = new NioEventLoopGroup();
            channelClass = NioServerSocketChannel.class;
        }
        return new ServerBootstrap()
                .group(bossGroup, workerGroup)
                .channel(channelClass)
                // 配置 编码器、解码器、业务处理
                .childHandler(new ChannelInitializer<SocketChannel>() {
                    @Override
                    protected void initChannel(SocketChannel ch) {
                        ch.pipeline().addLast(new ByteBufChannelHandler());
                    }
                })
                // tcp缓冲区
                .option(ChannelOption.SO_BACKLOG, 128)
                // 将网络数据积累到一定的数量后,服务器端才发送出去,会造成一定的延迟。希望服务是低延迟的,建议将TCP_NODELAY设置为true
                .childOption(ChannelOption.TCP_NODELAY, false)
                // 保持长连接
                .childOption(ChannelOption.SO_KEEPALIVE, true);
    }

    /**
     * 销毁
     */
    @PreDestroy
    public void destroy() {
        workerGroup.shutdownGracefully();
        bossGroup.shutdownGracefully();
    }
}
