package com.af.v4.system.common.socket.core.channel.impl;

import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.common.plugins.core.ConvertTools;
import com.af.v4.system.common.socket.config.ClientEvent;
import com.af.v4.system.common.socket.core.channel.AbstractChannelHandler;
import com.af.v4.system.common.socket.core.server.modbus.message.MBAPHeader;
import com.af.v4.system.common.socket.core.server.modbus.message.PduPayload;
import com.af.v4.system.common.socket.core.server.modbus.util.MBAPHeaderDecoder;
import io.netty.buffer.DefaultByteBufHolder;
import io.netty.channel.ChannelHandlerContext;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;

import static com.af.v4.system.common.socket.core.client.modbus.ModBusClient.modBusEventMap;


/**
 * @Classname TCPModbusChannelHandler
 * @Description TODO
 * @Date 2024/3/19 22:50
 * @Created by 张振宇
 */
public class ModbusTCPChannelHandler extends AbstractChannelHandler<DefaultByteBufHolder> {

    public static final int HEADER_LENGTH = 8;// // transactionId(2) + protocolId(2) + length(2) + unitId(1)+ functionCode(1)

    private final Logger LOGGER = LoggerFactory.getLogger(ModbusTCPChannelHandler.class);

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, DefaultByteBufHolder msg) {
        int totalLen = msg.content().readableBytes();
        if (totalLen < HEADER_LENGTH) {
            LOGGER.info("not modbus TCP protocol:");
            return;
        }
        //header
        MBAPHeader mbapHeader = MBAPHeaderDecoder.decode(msg.content());
        //pdu
        PduPayload pduPayload = new PduPayload();
        short functionCode = msg.content().readUnsignedByte();
        pduPayload.setFunctionCode(functionCode);
        int dataLength = 0;
        if (totalLen > HEADER_LENGTH) {
            dataLength = totalLen - HEADER_LENGTH;
        }
        pduPayload.setDataLength((short) dataLength);
        byte[] data = new byte[dataLength];
        msg.content().readBytes(data);
        pduPayload.setData(data);
        ClientEvent event = modBusEventMap.get(mbapHeader.getTransactionId());
        String _data = switch (event.getDecodeType()) {
            default -> Arrays.toString(pduPayload.getRealData());
            case FLOAT -> Float.toString(ConvertTools.bytesToFloat(pduPayload.getRealData()));
            case BYTE_TO_SCALED_INT -> Integer.toString(ConvertTools.bytesToInt(pduPayload.getRealData(), 0));
        };
        JSONObject logicParam = new JSONObject();
        logicParam.put("event",event);
        logicParam.put(event.getAlias(),_data);
        SpringUtils.getBean(LogicService.class).run(event.getLogicName(), logicParam);
    }
}