package com.af.v4.system.common.socket.core.channel.impl;

import com.af.v4.system.common.plugins.core.ConvertTools;
import com.af.v4.system.common.socket.core.server.modbus.dataProcessor.SendMessageStrategy;
import com.af.v4.system.common.socket.core.server.modbus.message.TCPModbusMessage;
import com.af.v4.system.common.socket.core.server.modbus.util.MBAPHeaderEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * @Classname ModbusResponseEncoder
 * @Description TODO
 * @Date 2024/3/19 23:06
 * @Created by 张振宇
 */

@Component
public class ModbusResponseEncoder extends MessageToByteEncoder<TCPModbusMessage> {
    private final Logger LOGGER = LoggerFactory.getLogger(ModbusResponseEncoder.class);

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, TCPModbusMessage tcpModbusMessage, ByteBuf byteBuf) {
        MBAPHeaderEncoder.encode(byteBuf, tcpModbusMessage.mbapHeader);
        int functionCode = tcpModbusMessage.pduPayload.getFunctionCode();
        SendMessageStrategy sendMessageStrategy = new SendMessageStrategy();
        sendMessageStrategy.sendMessage(byteBuf, tcpModbusMessage.pduPayload);
        LOGGER.info("TCPModbusReqEncoder:{} header:{} functionCode:{}", channelHandlerContext.channel().remoteAddress(), tcpModbusMessage.mbapHeader, functionCode);
        LOGGER.info("data:{}", ConvertTools.byteToHexStr((tcpModbusMessage.pduPayload.getData())));
    }
}
