/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.client.modbus;

import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.liuli.utils.enums.OSTypeEnum;
import com.af.v4.system.common.socket.config.ClientEvent;
import com.af.v4.system.common.socket.config.SocketClientConfigItem;
import com.af.v4.system.common.socket.core.channel.impl.ModbusRequestDecoder;
import com.af.v4.system.common.socket.core.channel.impl.ModbusResponseEncoder;
import com.af.v4.system.common.socket.core.channel.impl.ModbusTCPChannelHandler;
import com.af.v4.system.common.socket.core.server.SocketClient;
import com.af.v4.system.common.socket.core.server.modbus.message.ModbusSendUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;

public class ModBusClient
extends SocketClient<ServerChannel> {
    public static final ConcurrentHashMap<Short, ClientEvent> modBusEventMap = new ConcurrentHashMap(128);
    private EventLoopGroup group;

    @Override
    protected Bootstrap initBootstrap(SocketClientConfigItem socketConfigItem) {
        Class<EpollSocketChannel> channelClass;
        if (ApplicationUtils.getOSType() == OSTypeEnum.LINUX) {
            this.group = new EpollEventLoopGroup();
            channelClass = EpollSocketChannel.class;
        } else {
            this.group = new NioEventLoopGroup();
            channelClass = NioSocketChannel.class;
        }
        return (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channel(channelClass)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(this){

            protected void initChannel(SocketChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new ModbusRequestDecoder()});
                ch.pipeline().addLast(new ChannelHandler[]{new ModbusResponseEncoder()});
                ch.pipeline().addLast(new ChannelHandler[]{new ModbusTCPChannelHandler()});
            }
        });
    }

    @Override
    @PreDestroy
    public void destroy() {
        if (this.group != null) {
            this.group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void senMes(SocketClientConfigItem socketClientConfigItem) {
        if (!socketClientConfigItem.getEvents().isEmpty()) {
            int taskCount = (int)Math.ceil((double)socketClientConfigItem.getEvents().size() / 2.0) + 1;
            ScheduledExecutorService executor = null;
            try {
                executor = Executors.newScheduledThreadPool(taskCount);
                List<Runnable> tasks = socketClientConfigItem.getEvents().stream().map(event -> () -> {
                    short transactionIdentifier = ModbusSendUtil.getTransactionIdentifier(event.getAddress(), event.getLength());
                    modBusEventMap.put(transactionIdentifier, (ClientEvent)event);
                    event.setTransactionId(transactionIdentifier);
                    ModbusSendUtil.readData(socketClientConfigItem.getAddress(), event);
                }).toList();
                for (int i = 0; i < tasks.size(); ++i) {
                    Runnable task = tasks.get(i);
                    long interval = socketClientConfigItem.getEvents().get(i).getTime();
                    executor.scheduleAtFixedRate(task, 0L, interval, TimeUnit.SECONDS);
                }
            }
            finally {
                if (executor != null) {
                    executor.shutdown();
                }
            }
        }
    }
}

