/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.client;

import com.af.v4.system.common.plugins.core.ConvertTools;
import com.af.v4.system.common.socket.config.SocketConfigItem;
import com.af.v4.system.common.socket.core.channel.ChannelData;
import com.af.v4.system.common.socket.enums.MsgTypeEnum;
import io.netty.channel.Channel;
import io.netty.util.HashedWheelTimer;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class ClientManager {
    private static final ThreadLocal<ChannelData> clientChannels = new ThreadLocal();
    private static volatile HashedWheelTimer TIMER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashedWheelTimer getTimer() {
        if (TIMER != null) return TIMER;
        Class<ClientManager> clazz = ClientManager.class;
        synchronized (ClientManager.class) {
            if (TIMER != null) return TIMER;
            TIMER = new HashedWheelTimer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return TIMER;
        }
    }

    public static void add(ChannelData channelData) {
        clientChannels.set(channelData);
    }

    public static void remove() {
        clientChannels.remove();
    }

    public static void delayedSend(String message, Integer sleepTime) {
        ClientManager.getTimer().newTimeout(timeout -> ClientManager.send(message), Long.parseLong(sleepTime.toString()), TimeUnit.MILLISECONDS);
    }

    public static void send(String message) {
        ChannelData channelData = clientChannels.get();
        Channel channel = channelData.channel();
        if (channel != null) {
            byte[] sendMsgBytes = switch (channelData.configItem().getEncodeType()) {
                default -> message.getBytes();
                case MsgTypeEnum.BASE64 -> ConvertTools.base64Decode((byte[])message.getBytes());
                case MsgTypeEnum.HEX -> ConvertTools.hexStrToByte((String)message);
                case MsgTypeEnum.HEX_BASE64 -> ConvertTools.base64Decode((byte[])ConvertTools.hexStrToByte((String)message));
            };
            channel.writeAndFlush((Object)channel.alloc().buffer().writeBytes(sendMsgBytes));
        }
    }

    public static SocketConfigItem getConfig() {
        return clientChannels.get().configItem();
    }

    public static ChannelData getChannelData() {
        return clientChannels.get();
    }

    public static void setGlobalParams(String key, Object value) {
        ChannelData channelData = ClientManager.getChannelData();
        JSONObject globalParamsItem = channelData.globalParams();
        globalParamsItem.put(key, value);
    }

    public static Object getGlobalParams(String key) {
        ChannelData channelData = ClientManager.getChannelData();
        JSONObject globalParamsItem = channelData.globalParams();
        return globalParamsItem.opt(key);
    }
}

