package com.af.v4.system.common.socket.core.channel.impl;

import com.af.v4.system.common.socket.core.channel.AbstractChannelHandler;
import com.af.v4.system.common.socket.core.client.ClientManager;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteBufChannelHandler extends AbstractChannelHandler<ByteBuf> {

    private final Logger LOGGER = LoggerFactory.getLogger(ByteBufChannelHandler.class);

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf message) {
        LOGGER.debug("channelId:{}, 收到消息", ctx.channel().id());
        String response = runBusiness(message, ctx.channel().remoteAddress().toString());
        try {
            ClientManager.send(response);
        } finally {
            message.release();
        }
    }
}
