/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.server;

import com.af.v4.system.common.socket.config.SocketConfigItem;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SocketServer<B extends AbstractBootstrap<B, C>, C extends Channel> {
    private final Logger LOGGER = LoggerFactory.getLogger(SocketServer.class);

    public void run(SocketConfigItem socketConfigItem) {
        String socketType = socketConfigItem.getType().getValue();
        this.LOGGER.info("\u5f00\u59cb\u521d\u59cb\u5316{}\u670d\u52a1\u7aef[{}],\u76d1\u542c\u7aef\u53e3{},\u56de\u8c03\u4e1a\u52a1\u903b\u8f91\u540d[{}]", new Object[]{socketType, socketConfigItem.getName(), socketConfigItem.getPorts(), socketConfigItem.getLogicName()});
        AbstractBootstrap<B, C> bootstrap = this.initBootstrap();
        socketConfigItem.getPorts().forEach(port -> {
            try {
                ChannelFuture channelFuture = bootstrap.bind(Integer.parseInt(port.toString())).sync();
                channelFuture.channel().closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)future -> future.channel().close()));
            }
            catch (InterruptedException e) {
                this.LOGGER.error("\u542f\u52a8{}\u670d\u52a1\u7aef[{}]\u65f6\u53d1\u751f\u5f02\u5e38", new Object[]{socketType, socketConfigItem.getName(), e});
                throw new RuntimeException(e);
            }
        });
    }

    protected abstract AbstractBootstrap<B, C> initBootstrap();

    public abstract void destroy();
}

