/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.server;

import com.af.v4.system.common.socket.config.SocketClientConfigItem;
import com.af.v4.system.common.socket.core.client.ChannelManager;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SocketClient<C extends Channel>
extends Bootstrap {
    private final Logger LOGGER = LoggerFactory.getLogger(SocketClient.class);

    public void connect(SocketClientConfigItem socketConfigItem) {
        String socketType = socketConfigItem.getType().getValue();
        this.LOGGER.info("\u5f00\u59cb\u8fde\u63a5{}\u670d\u52a1\u7aef[{}],\u76d1\u542c\u7aef\u53e3{}", new Object[]{socketType, socketConfigItem.getName(), socketConfigItem.getAddress()});
        Bootstrap bootstrap = this.initBootstrap(socketConfigItem);
        try {
            bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)(socketConfigItem.getConnectionTimeout() * 1000));
            ChannelFuture channelFuture = bootstrap.connect((SocketAddress)new InetSocketAddress(socketConfigItem.getHost(), (int)socketConfigItem.getPort())).sync();
            if (channelFuture.isSuccess()) {
                ChannelManager.add(socketConfigItem, channelFuture.channel());
                this.senMes(socketConfigItem);
                channelFuture.channel().closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)future -> future.channel().close()));
            }
        }
        catch (InterruptedException e) {
            this.LOGGER.error("\u542f\u52a8{}\u670d\u52a1\u7aef[{}]\u65f6\u53d1\u751f\u5f02\u5e38", new Object[]{socketType, socketConfigItem.getName(), e});
            throw new RuntimeException(e);
        }
    }

    protected abstract Bootstrap initBootstrap(SocketClientConfigItem var1);

    public abstract void destroy();

    public abstract void senMes(SocketClientConfigItem var1);
}

