/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.config;

import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.system.common.socket.config.SocketConfigItem;
import com.af.v4.system.common.socket.enums.MsgTypeEnum;
import com.af.v4.system.common.socket.enums.SocketTypeEnum;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class SocketConfig {
    private static final String CONFIG_NAME = "SocketConfig";
    private List<SocketConfigItem> socketConfigItemList;

    public SocketConfig(LiuLiConfigService liuLiConfigService) {
        JSONObject config = liuLiConfigService.get(CONFIG_NAME);
        if (config == null) {
            return;
        }
        JSONArray socketServerList = config.optJSONArray("server");
        if (socketServerList == null) {
            return;
        }
        this.socketConfigItemList = new ArrayList<SocketConfigItem>(socketServerList.length());
        socketServerList.forEach(item -> {
            JSONObject itemObj = (JSONObject)item;
            this.socketConfigItemList.add(new SocketConfigItem().setName(itemObj.getString("name")).setType(SocketTypeEnum.toType(itemObj.getString("type"))).setEncodeType(MsgTypeEnum.toType(itemObj.getString("encodeType"))).setDecodeType(MsgTypeEnum.toType(itemObj.getString("decodeType"))).setPorts(itemObj.getJSONArray("ports")).setLogicName(itemObj.getString("logicName")));
        });
    }

    public List<SocketConfigItem> getSocketServerList() {
        return this.socketConfigItemList;
    }
}

