/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.server.modbus.message;

import com.af.v4.system.common.socket.config.ClientEvent;
import com.af.v4.system.common.socket.core.channel.ChannelData;
import com.af.v4.system.common.socket.core.client.ChannelManager;
import com.af.v4.system.common.socket.core.client.ClientManager;
import com.af.v4.system.common.socket.core.server.modbus.message.MBAPHeader;
import com.af.v4.system.common.socket.core.server.modbus.message.PduPayload;
import com.af.v4.system.common.socket.core.server.modbus.message.TCPModbusMessage;
import com.af.v4.system.common.socket.core.server.modbus.message.TCPModbusMessageFactory;
import io.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusSendUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModbusSendUtil.class);

    public static void readData(String ip, ClientEvent event) {
        Channel channel = ChannelManager.getChannel(ip);
        if (channel != null) {
            MBAPHeader mbapHeader = ModbusSendUtil.createMbapHeader(event);
            PduPayload pduPayload = ModbusSendUtil.createPduPayload(event);
            TCPModbusMessage tcpModbusMessage = new TCPModbusMessage();
            tcpModbusMessage.mbapHeader = mbapHeader;
            tcpModbusMessage.pduPayload = pduPayload;
            channel.writeAndFlush((Object)tcpModbusMessage);
        }
    }

    private static MBAPHeader createMbapHeader(ClientEvent event) {
        return TCPModbusMessageFactory.newReadReqHeader(event);
    }

    private static PduPayload createPduPayload(ClientEvent event) {
        int functionCode = event.getFunctionCode();
        return switch (functionCode) {
            case 1 -> TCPModbusMessageFactory.newReadCoilsReqPdu(event);
            case 3 -> TCPModbusMessageFactory.newReadHoldingRegistersReqPdu(event);
            default -> throw new RuntimeException("not support function code..." + functionCode);
        };
    }

    public String writeSingleCoil(String ip) {
        ChannelData channelData = ClientManager.getChannelData();
        Channel channel = channelData.channel();
        if (channel != null) {
            MBAPHeader mbapHeader = TCPModbusMessageFactory.newWriteSingleCoilReqHeader();
            PduPayload pduPayload = TCPModbusMessageFactory.newWriteSingleCoilReqPdu();
            TCPModbusMessage tcpModbusMessage = new TCPModbusMessage();
            tcpModbusMessage.mbapHeader = mbapHeader;
            tcpModbusMessage.pduPayload = pduPayload;
            channel.writeAndFlush((Object)tcpModbusMessage);
            return "sucess";
        }
        return "fail";
    }

    public String writeSingleRegister(String ip) {
        ChannelData channelData = ClientManager.getChannelData();
        Channel channel = channelData.channel();
        if (channel != null) {
            MBAPHeader mbapHeader = TCPModbusMessageFactory.newWriteSingleRegisterReqHeader();
            PduPayload pduPayload = TCPModbusMessageFactory.newWriteSingleRegisterReqPdu();
            TCPModbusMessage tcpModbusMessage = new TCPModbusMessage();
            tcpModbusMessage.mbapHeader = mbapHeader;
            tcpModbusMessage.pduPayload = pduPayload;
            channel.writeAndFlush((Object)tcpModbusMessage);
            return "sucess";
        }
        return "fail";
    }

    public static short getTransactionIdentifier(String address, int length) {
        int addressInt = Integer.parseInt(address);
        int transactionIdentifier = addressInt + length;
        if (transactionIdentifier > Short.MAX_VALUE) {
            transactionIdentifier = transactionIdentifier % 32768 - 32768;
        }
        return (short)transactionIdentifier;
    }
}

