/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.client;

import com.af.v4.system.common.socket.config.SocketClientConfigItem;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.CollectionUtils;

public class ChannelManager {
    private static final ConcurrentHashMap<String, Channel> channelMap = new ConcurrentHashMap(128);

    public static ConcurrentHashMap<String, Channel> getChannelMap() {
        return channelMap;
    }

    public static Channel getChannel(String channelId) {
        if (CollectionUtils.isEmpty(channelMap)) {
            return null;
        }
        return channelMap.get(channelId);
    }

    public static void add(SocketClientConfigItem socketClientConfigItem, Channel channel) {
        channelMap.put(socketClientConfigItem.getAddress(), channel);
    }

    public static boolean removeChannel(String channelId) {
        if (channelMap.containsKey(channelId)) {
            channelMap.remove(channelId);
            return true;
        }
        return false;
    }

    public static List<String> list() {
        ArrayList<String> list = new ArrayList<String>();
        if (CollectionUtils.isEmpty(channelMap)) {
            return null;
        }
        for (Map.Entry<String, Channel> iterator : channelMap.entrySet()) {
            String channelId = iterator.getKey();
            Channel channel = iterator.getValue();
            list.add(channelId);
        }
        return list;
    }
}

