/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.config;

import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.system.common.socket.config.ClientEvent;
import com.af.v4.system.common.socket.config.SocketClientConfigItem;
import com.af.v4.system.common.socket.config.SocketConfigItem;
import com.af.v4.system.common.socket.enums.MsgTypeEnum;
import com.af.v4.system.common.socket.enums.SocketTypeEnum;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SocketConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(SocketConfig.class);
    private static final String CONFIG_NAME = "SocketConfig";
    private static final String CLIENT_CONFIG_NAME = "SocketClientConfig";
    private List<SocketConfigItem> socketConfigItemList;
    private List<SocketClientConfigItem> socketClientConfigItemList;

    public SocketConfig(LiuLiConfigService liuLiConfigService) {
        JSONArray socketClientList;
        JSONObject client_config;
        JSONArray socketServerList;
        JSONObject config = liuLiConfigService.get(CONFIG_NAME);
        if (config != null && (socketServerList = config.optJSONArray("server")) != null) {
            this.socketConfigItemList = this.parseSocketConfigItems(socketServerList);
        }
        if ((client_config = liuLiConfigService.get(CLIENT_CONFIG_NAME)) != null && (socketClientList = client_config.optJSONArray("server")) != null) {
            this.socketClientConfigItemList = this.parseSocketClientConfigItems(socketClientList);
        }
    }

    private List<SocketConfigItem> parseSocketConfigItems(JSONArray socketServerList) {
        ArrayList<SocketConfigItem> list = new ArrayList<SocketConfigItem>(socketServerList.length());
        socketServerList.forEach(item -> {
            JSONObject itemObj = (JSONObject)item;
            list.add(new SocketConfigItem().setName(itemObj.getString("name")).setType(SocketTypeEnum.toType(itemObj.getString("type"))).setEncodeType(MsgTypeEnum.toType(itemObj.getString("encodeType"))).setDecodeType(MsgTypeEnum.toType(itemObj.getString("decodeType"))).setPorts(itemObj.getJSONArray("ports")).setLogicName(itemObj.getString("logicName")));
        });
        return list;
    }

    private List<SocketClientConfigItem> parseSocketClientConfigItems(JSONArray socketClientList) {
        ArrayList<SocketClientConfigItem> list = new ArrayList<SocketClientConfigItem>(socketClientList.length());
        socketClientList.forEach(item -> {
            try {
                JSONObject itemObj = (JSONObject)item;
                if (itemObj.optBoolean("enable", false)) {
                    list.add(new SocketClientConfigItem().setName(itemObj.getString("name")).setType(SocketTypeEnum.toType(itemObj.getString("type"))).setEncodeType(MsgTypeEnum.toType(itemObj.optString("encodeType", "NORMAL"))).setDecodeType(MsgTypeEnum.toType(itemObj.optString("decodeType", "NORMAL"))).setPorts(itemObj.getInt("port")).setHost(itemObj.getString("host")).setConnectionTimeout(itemObj.optInt("connectionTimeout", 10)).setReadTimeout(itemObj.optInt("readTimeout", 30)).setEvents(itemObj.optJSONArray("events") == null ? new ArrayList<ClientEvent>() : this.parseModbusEvents(itemObj.optJSONArray("events"))));
                }
            }
            catch (JSONException e) {
                this.LOGGER.error("\u5ba2\u6237\u7aef\u4fe1\u606f\u6dfb\u52a0\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.toString());
            }
        });
        return list;
    }

    private List<ClientEvent> parseModbusEvents(JSONArray events) {
        ArrayList<ClientEvent> list = new ArrayList<ClientEvent>(events.length());
        for (Object item : events) {
            try {
                JSONObject itemObj = (JSONObject)item;
                int functionCode = itemObj.getInt("functionCode");
                if (functionCode != 3 && functionCode != 1) {
                    this.LOGGER.error("modBus\u4e8b\u4ef6\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a\u6682\u53ea\u652f\u6301\u529f\u80fd\u5417 1(\u8bfb\u7ebf\u5708)\uff0c3\uff08\u8bfb\u4fdd\u6301\u5bc4\u5b58\u5668\uff09");
                    continue;
                }
                list.add(new ClientEvent().setRemark(itemObj.getString("remark")).setAddress(itemObj.getString("address")).setFunctionCode(functionCode).setLength(itemObj.getInt("length")).setAlias(itemObj.getString("alias")).setTime(itemObj.optInt("time", 3)).setDecodeType(MsgTypeEnum.toType(itemObj.optString("decodeType", "NORMAL"))).setLogicName(itemObj.getString("logicName")));
            }
            catch (JSONException e) {
                this.LOGGER.error("modBus\u4e8b\u4ef6\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.toString());
            }
        }
        return list;
    }

    public List<SocketConfigItem> getSocketServerList() {
        return this.socketConfigItemList;
    }

    public List<SocketClientConfigItem> getSocketServerClientList() {
        return this.socketClientConfigItemList;
    }
}

