package com.af.v4.system.common.socket.core.client;

import com.af.v4.system.common.plugins.core.ConvertTools;
import com.af.v4.system.common.socket.config.SocketConfigItem;
import com.af.v4.system.common.socket.core.channel.ChannelData;
import io.netty.channel.Channel;
import org.json.JSONObject;

/**
 * 客户端管理器
 */
public class ClientManager {
    private static final ThreadLocal<ChannelData> clientChannels = new ThreadLocal<>();

    public static void add(ChannelData channelData) {
        clientChannels.set(channelData);
    }

    public static void remove() {
        clientChannels.remove();
    }

    public static void send(String message) {
        ChannelData channelData = clientChannels.get();
        Channel channel = channelData.channel();
        byte[] sendMsgBytes;
        if (channel != null) {
            sendMsgBytes = switch (channelData.configItem().getEncodeType()) {
                default -> message.getBytes();
                case BASE64 -> ConvertTools.base64Decode(message.getBytes());
                case HEX -> ConvertTools.hexStrToByte(message);
                case HEX_BASE64 -> ConvertTools.base64Decode(ConvertTools.hexStrToByte(message));
            };
            channel.writeAndFlush(channel.alloc().buffer().writeBytes(sendMsgBytes));
        }
    }

    public static SocketConfigItem getConfig() {
        return clientChannels.get().configItem();
    }

    public static ChannelData getChannelData() {
        return clientChannels.get();
    }

    /**
     * 设置全局参数
     *
     * @param key   参数key
     * @param value 值
     */
    public static void setGlobalParams(String key, Object value) {
        ChannelData channelData = ClientManager.getChannelData();
        JSONObject globalParamsItem = channelData.globalParams();
        globalParamsItem.put(key, value);
    }

    /**
     * 获取全局参数
     *
     * @param key 参数key
     */
    public static Object getGlobalParams(String key) {
        ChannelData channelData = ClientManager.getChannelData();
        JSONObject globalParamsItem = channelData.globalParams();
        return globalParamsItem.opt(key);
    }
}
