package com.af.v4.system.common.socket.core.channel.impl;

import com.af.v4.system.common.plugins.core.ConvertTools;
import com.af.v4.system.common.socket.config.SocketConfigItem;
import com.af.v4.system.common.socket.core.channel.AbstractChannelHandler;
import com.af.v4.system.common.socket.core.client.ClientManager;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.charset.StandardCharsets;

public class DatagramPacketChannelHandler extends AbstractChannelHandler<DatagramPacket> {

    private final Logger LOGGER = LoggerFactory.getLogger(DatagramPacketChannelHandler.class);

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket message) {
        SocketConfigItem configItem = ClientManager.getConfig();
        String response = runBusiness(message.content(), ctx.channel().remoteAddress().toString());
        byte[] respBytes = switch (configItem.getEncodeType()) {
            default -> response.getBytes(StandardCharsets.UTF_8);
            case BASE64 -> ConvertTools.base64Decode(response.getBytes());
            case HEX -> ConvertTools.hexStrToByte(response);
            case HEX_BASE64 -> ConvertTools.base64Decode(ConvertTools.hexStrToByte(response));
        };
        DatagramPacket packet = new DatagramPacket(new UnpooledByteBufAllocator(true).buffer().writeBytes(respBytes), message.sender());
        ctx.writeAndFlush(packet);
    }
}
