/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.channel.impl;

import com.af.v4.system.common.plugins.core.ConvertTools;
import com.af.v4.system.common.socket.core.server.modbus.dataProcessor.SendMessageStrategy;
import com.af.v4.system.common.socket.core.server.modbus.message.TCPModbusMessage;
import com.af.v4.system.common.socket.core.server.modbus.util.MBAPHeaderEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ModbusResponseEncoder
extends MessageToByteEncoder<TCPModbusMessage> {
    private final Logger LOGGER = LoggerFactory.getLogger(ModbusResponseEncoder.class);

    protected void encode(ChannelHandlerContext channelHandlerContext, TCPModbusMessage tcpModbusMessage, ByteBuf byteBuf) throws Exception {
        MBAPHeaderEncoder.encode(byteBuf, tcpModbusMessage.mbapHeader);
        int functionCode = tcpModbusMessage.pduPayload.getFunctionCode();
        SendMessageStrategy sendMessageStrategy = new SendMessageStrategy();
        sendMessageStrategy.sendMessage(byteBuf, tcpModbusMessage.pduPayload);
        this.LOGGER.info("TCPModbusReqEncoder:{} header:{} functionCode:{}", new Object[]{channelHandlerContext.channel().remoteAddress(), tcpModbusMessage.mbapHeader, functionCode});
        this.LOGGER.info("data:" + ConvertTools.byteToHexStr((byte[])tcpModbusMessage.pduPayload.getData()));
    }
}

