package com.af.v4.system.common.socket.core.client.tcp;

import com.af.v4.system.common.socket.config.SocketClientConfigItem;
import com.af.v4.system.common.socket.core.channel.impl.ByteBufChannelHandler;
import com.af.v4.system.common.socket.core.channel.impl.ModbusRequestDecoder;
import com.af.v4.system.common.socket.core.channel.impl.ModbusResponseEncoder;
import com.af.v4.system.common.socket.core.channel.impl.ModbusTCPChannelHandler;
import com.af.v4.system.common.socket.core.server.SocketClient;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.*;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.ReadTimeoutHandler;

import javax.annotation.PreDestroy;
import java.util.concurrent.TimeUnit;

/**
 * TCP客户端
 */
public class TcpClient  extends SocketClient<ServerChannel>{
    private EventLoopGroup group;

    @Override
    protected Bootstrap initBootstrap(SocketClientConfigItem socketConfigItem) {
        Class<? extends Channel> channelClass;
        if (isLinux()) {
            group = new EpollEventLoopGroup();
            channelClass = EpollSocketChannel.class;
        } else {
            group = new NioEventLoopGroup();
            channelClass = NioSocketChannel.class;
        }

        return new Bootstrap()
                .group(group)
                .channel(channelClass)
                .handler(new ChannelInitializer<SocketChannel>() {
                    @Override
                    protected void initChannel(SocketChannel ch) {
                        ch.pipeline().addLast(new ByteBufChannelHandler());
                    }
                });
    }

    @PreDestroy
    public void destroy() {
        if (group != null) {
            group.shutdownGracefully();
        }
    }

    @Override
    public void senMes(SocketClientConfigItem socketClientConfigItem) {
        System.out.println("发送事件"+socketClientConfigItem);
    }
}