/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.client;

import com.af.v4.system.common.plugins.core.ConvertTools;
import com.af.v4.system.common.socket.config.SocketConfigItem;
import com.af.v4.system.common.socket.core.channel.ChannelData;
import com.af.v4.system.common.socket.enums.MsgTypeEnum;
import io.netty.channel.Channel;

public class ClientManager {
    private static final ThreadLocal<ChannelData> clientChannels = new ThreadLocal();

    public static void add(ChannelData channelData) {
        clientChannels.set(channelData);
    }

    public static void remove() {
        clientChannels.remove();
    }

    public static void send(String message) {
        ChannelData channelData = clientChannels.get();
        Channel channel = channelData.channel();
        if (channel != null) {
            byte[] sendMsgBytes = switch (channelData.configItem().getEncodeType()) {
                default -> message.getBytes();
                case MsgTypeEnum.BASE64 -> ConvertTools.base64Decode((byte[])message.getBytes());
                case MsgTypeEnum.HEX -> ConvertTools.hexStrToByte((String)message);
                case MsgTypeEnum.HEX_BASE64 -> ConvertTools.base64Decode((byte[])ConvertTools.hexStrToByte((String)message));
            };
            channel.writeAndFlush((Object)channel.alloc().buffer().writeBytes(sendMsgBytes));
        }
    }

    public static SocketConfigItem getConfig() {
        return clientChannels.get().configItem();
    }
}

