package com.af.v4.system.common.socket.config;

import com.af.v4.system.common.socket.enums.MsgTypeEnum;
import com.af.v4.system.common.socket.enums.SocketTypeEnum;

import java.util.List;

/**
 * Socket服务端
 *
 * @author Mr.river
 */
public class SocketConfigItem {

    /**
     * 服务端类型(tcp,udp)
     */
    private String type;
    /**
     * 服务端名称
     */
    private String name;
    /**
     * 监听端口集合
     */
    private List<Integer> port;
    /**
     * 接收数据的logic名称
     */
    private String logicName;
    /**
     * 编码类型
     */
    private String encodeType;
    /**
     * 解码类型
     */
    private String decodeType;

    public SocketTypeEnum getType() {
        return SocketTypeEnum.toType(type);
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Integer> getPort() {
        return port;
    }

    public void setPort(List<Integer> port) {
        this.port = port;
    }

    public String getLogicName() {
        return logicName;
    }

    public void setLogicName(String logicName) {
        this.logicName = logicName;
    }

    public MsgTypeEnum getEncodeType() {
        return MsgTypeEnum.toType(encodeType);
    }

    public void setEncodeType(String encodeType) {
        this.encodeType = encodeType;
    }

    public MsgTypeEnum getDecodeType() {
        return MsgTypeEnum.toType(decodeType);
    }

    public void setDecodeType(String decodeType) {
        this.decodeType = decodeType;
    }
}
