package com.af.v4.system.common.socket.enums;

import java.util.stream.Stream;

/**
 * socket类型
 */
public enum SocketTypeEnum {
    //TC
    TCP("tcp"),
    //UDP
    UDP("udp");

    private final String value;

    SocketTypeEnum(String value) {
        this.value = value;
    }

    public static SocketTypeEnum toType(String value) {
        return Stream.of(SocketTypeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(TCP);
    }

    public static boolean is(String value) {
        return toType(value) != null;
    }

    public String getValue() {
        return value;
    }
}
