/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.channel.impl;

import com.af.v4.system.common.plugins.core.ConvertTools;
import com.af.v4.system.common.socket.config.SocketConfigItem;
import com.af.v4.system.common.socket.core.channel.AbstractChannelHandler;
import com.af.v4.system.common.socket.core.client.ClientManager;
import com.af.v4.system.common.socket.enums.MsgTypeEnum;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatagramPacketChannelHandler
extends AbstractChannelHandler<DatagramPacket> {
    private final Logger LOGGER = LoggerFactory.getLogger(DatagramPacketChannelHandler.class);

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket message) {
        SocketConfigItem configItem = ClientManager.getConfig();
        String response = this.runBusiness((ByteBuf)message.content());
        byte[] respBytes = switch (configItem.getEncodeType()) {
            default -> response.getBytes(StandardCharsets.UTF_8);
            case MsgTypeEnum.BASE64 -> ConvertTools.base64Decode((byte[])response.getBytes());
            case MsgTypeEnum.HEX -> ConvertTools.hexStrToByte((String)response);
            case MsgTypeEnum.HEX_BASE64 -> ConvertTools.base64Decode((byte[])ConvertTools.hexStrToByte((String)response));
        };
        DatagramPacket packet = new DatagramPacket(new UnpooledByteBufAllocator(true).buffer().writeBytes(respBytes), (InetSocketAddress)message.sender());
        ctx.writeAndFlush((Object)packet);
    }
}

