package com.af.v4.system.common.socket.core.channel;

import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.common.plugins.core.ConvertTools;
import com.af.v4.system.common.socket.SocketServerManager;
import com.af.v4.system.common.socket.config.SocketConfigItem;
import com.af.v4.system.common.socket.core.client.ClientManager;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.InetSocketAddress;

public abstract class AbstractChannelHandler<T> extends SimpleChannelInboundHandler<T> {

    private final Logger LOGGER = LoggerFactory.getLogger(AbstractChannelHandler.class);

    @Override
    protected abstract void channelRead0(ChannelHandlerContext ctx, T msg);

    protected String runBusiness(ByteBuf content) {
        SocketConfigItem configItem = ClientManager.getConfig();
        byte[] data = new byte[content.readableBytes()];
        content.readBytes(data);

        String realData = switch (configItem.getDecodeType()) {
            default -> ConvertTools.bytesToStr(data);
            case HEX -> ConvertTools.byteToHexStr(data);
        };

        JSONObject params = new JSONObject();
        params.put("value", realData);
        return SpringUtils.getBean(LogicService.class).run(configItem.getLogicName(), params).toString();
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        String channelId = ctx.channel().id().asLongText();
        LOGGER.debug("成功建立连接,channelId：{}", channelId);
        String port = String.valueOf(((InetSocketAddress) ctx.channel().localAddress()).getPort());
        SocketConfigItem configItem = SocketServerManager.getSocketConfigItemByPort(port);
        ClientManager.add(new ChannelData(configItem, ctx.channel()));
        super.channelActive(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            ClientManager.remove();
            ctx.close();
        } catch (Exception e) {
            LOGGER.error("关闭通道时发生异常", e);
        }
        super.channelInactive(ctx);
    }
}
