package com.af.v4.system.common.security.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;

/**
 * Token配置属性
 */
@Configuration
@RefreshScope
@ConfigurationProperties(prefix = "security.token")
public class TokenProperties {

    /**
     * Token过期时间（分钟），默认7天（10080分钟）
     */
    private Long expiration = 10080L;

    /**
     * Token刷新时间（分钟），默认1天（1440分钟）
     * 当token距离过期时间少于此时间时，会自动刷新token
     */
    private Long refreshTime = 1440L;

    /**
     * 外部用户Token过期时间（分钟），默认1小时（60分钟）
     * 外部用户（第三方平台登录）的token过期时间相对较短，提高安全性
     */
    private Long externalUserExpiration = 60L;

    public Long getExpiration() {
        return expiration;
    }

    public void setExpiration(Long expiration) {
        this.expiration = expiration;
    }

    public Long getRefreshTime() {
        return refreshTime;
    }

    public void setRefreshTime(Long refreshTime) {
        this.refreshTime = refreshTime;
    }

    public Long getExternalUserExpiration() {
        return externalUserExpiration;
    }

    public void setExternalUserExpiration(Long externalUserExpiration) {
        this.externalUserExpiration = externalUserExpiration;
    }

    @Override
    public String toString() {
        return "TokenProperties{" +
                "expiration=" + expiration +
                ", refreshTime=" + refreshTime +
                ", externalUserExpiration=" + externalUserExpiration +
                '}';
    }
}