package com.af.v4.system.common.security.config;

import com.af.v4.system.common.security.filter.ScopedUserContextFilter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FilterConfig {
    @Bean
    public FilterRegistrationBean<ScopedUserContextFilter> scopedUserContextFilter() {
        FilterRegistrationBean<ScopedUserContextFilter> registration = new FilterRegistrationBean<>();
        registration.setFilter(new ScopedUserContextFilter());
        registration.addUrlPatterns("/*");
        registration.setOrder(-10);
        registration.addInitParameter("exclusions", "/login,/logout,/refresh");
        return registration;
    }
}
