/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.security.service;

import cn.hutool.crypto.SecureUtil;
import com.af.v4.system.api.model.LoginUser;
import com.af.v4.system.common.core.utils.JwtUtils;
import com.af.v4.system.common.core.utils.ServletUtils;
import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.core.utils.ip.IpUtils;
import com.af.v4.system.common.core.utils.uuid.IdUtils;
import com.af.v4.system.common.plugins.core.SecureTools;
import com.af.v4.system.common.redis.RedisService;
import com.af.v4.system.common.security.utils.SecurityUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TokenService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenService.class);
    protected static final long MILLIS_SECOND = 1000L;
    protected static final long MILLIS_MINUTE = 60000L;
    private static final Long MILLIS_MINUTE_TEN = 86400000L;
    private final RedisService redisService;

    public TokenService(RedisService redisService) {
        this.redisService = redisService;
    }

    public Map<String, Object> createToken(LoginUser loginUser) {
        String token = IdUtils.fastUUID();
        Long userId = loginUser.getSysUser().getUserId();
        String userName = loginUser.getSysUser().getUserName();
        loginUser.setToken(token);
        loginUser.setUserid(userId);
        loginUser.setUsername(userName);
        loginUser.setIpaddr(IpUtils.getIpAddr());
        loginUser.setSessionEncryptKey(SecureUtil.sha256((String)token).substring(0, 32));
        this.refreshToken(loginUser);
        HashMap<String, Object> claimsMap = new HashMap<String, Object>(3);
        claimsMap.put("user_key", token);
        claimsMap.put("id", userId);
        claimsMap.put("f_username", userName);
        HashMap<String, Object> rspMap = new HashMap<String, Object>(3);
        rspMap.put("access_token", JwtUtils.createToken(claimsMap));
        rspMap.put("expires_in", 10080L);
        rspMap.put("session", SecureTools.RSAEncrypt((String)loginUser.getSessionEncryptKey(), (String)"MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCEa5n7SwxwkKkRBCdd9jp7vlt75hW3Re0A++dUq3Awxg0387s9cwbhJb5B4bgwW+ymZF6wiHvjIb19iL8XCzm5d32l/nr2JZ349h0WxdISKUC7iKttrS9OmXFecO8Ki8VGUaRRJSBZvIGU5FL3yl1bh8PPXuHWg1YVOYStxhzRkwIDAQAB"));
        rspMap.put("resources", loginUser.getResources());
        return rspMap;
    }

    public LoginUser getLoginUser() {
        return this.getLoginUser(ServletUtils.getRequest());
    }

    public void setLoginUser(LoginUser loginUser) {
        if (StringUtils.isNotNull((Object)loginUser) && StringUtils.isNotEmpty((String)loginUser.getToken())) {
            this.refreshToken(loginUser);
        }
    }

    public LoginUser getLoginUser(HttpServletRequest request) {
        String token = SecurityUtils.getToken(request);
        return this.getLoginUser(token);
    }

    public LoginUser getLoginUser(String token) {
        LoginUser user = null;
        try {
            if (StringUtils.isNotEmpty((String)token)) {
                String userKey = JwtUtils.getUserKey((String)token);
                user = (LoginUser)this.redisService.get(this.getTokenKey(userKey));
                return user;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38'{}'", (Object)e.getMessage());
        }
        return user;
    }

    public void delLoginUser(String token) {
        if (StringUtils.isNotEmpty((String)token)) {
            String userKey = JwtUtils.getUserKey((String)token);
            this.redisService.delete(this.getTokenKey(userKey));
            this.redisService.delete(this.getSecureKey(userKey));
        }
    }

    public void verifyToken(LoginUser loginUser) {
        long currentTime;
        long expireTime = loginUser.getExpireTime();
        if (expireTime - (currentTime = System.currentTimeMillis()) <= MILLIS_MINUTE_TEN) {
            this.refreshToken(loginUser);
        }
    }

    public void refreshToken(LoginUser loginUser) {
        loginUser.setLoginTime(Long.valueOf(System.currentTimeMillis()));
        loginUser.setExpireTime(Long.valueOf(loginUser.getLoginTime() + 604800000L));
        String userKey = this.getTokenKey(loginUser.getToken());
        this.redisService.set(userKey, (Object)loginUser, (Object)604800L);
        String secureKey = this.getSecureKey(loginUser.getToken());
        this.redisService.set(secureKey, (Object)loginUser.getSessionEncryptKey(), (Object)604800L);
    }

    private String getTokenKey(String token) {
        return "login_tokens:" + token;
    }

    private String getSecureKey(String token) {
        return "session_secure_key:" + token;
    }
}

