/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.security.interceptor;

import com.af.v4.system.api.model.LoginUser;
import com.af.v4.system.common.core.context.SecurityContextHolder;
import com.af.v4.system.common.core.utils.ServletUtils;
import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.security.auth.AuthUtil;
import com.af.v4.system.common.security.utils.SecurityUtils;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.security.SignatureException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.AsyncHandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class HeaderInterceptor
implements AsyncHandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeaderInterceptor.class);

    public void postHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, @Nullable ModelAndView modelAndView) throws Exception {
        String userIdValue = ServletUtils.getHeader((HttpServletRequest)request, (String)"id");
        String userNameValue = ServletUtils.getHeader((HttpServletRequest)request, (String)"f_username");
        String userKeyValue = ServletUtils.getHeader((HttpServletRequest)request, (String)"user_key");
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>(6);
        map.put("id", userIdValue == null ? "" : userIdValue);
        map.put("f_username", userNameValue == null ? "" : userNameValue);
        map.put("user_key", userKeyValue == null ? "" : userKeyValue);
        String token = SecurityUtils.getToken();
        if (StringUtils.isNotEmpty((String)token)) {
            LoginUser loginUser;
            try {
                loginUser = AuthUtil.getLoginUser(token);
            }
            catch (MalformedJwtException | SignatureException e) {
                loginUser = null;
            }
            catch (JwtException e) {
                LOGGER.error("\u6821\u9a8c\u51fa\u9519", (Throwable)e);
                loginUser = null;
            }
            if (StringUtils.isNotNull((Object)loginUser)) {
                AuthUtil.verifyLoginUserExpire(loginUser);
                map.put("login_user", (String)loginUser);
            }
        }
        ScopedValue.where(SecurityContextHolder.getScopedUserInfo(), map).run(() -> {
            try {
                super.postHandle(request, response, handler, modelAndView);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }
}

