/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.security.auth;

import com.af.v4.system.api.model.LoginUser;
import com.af.v4.system.common.core.exception.auth.NotLoginException;
import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.security.service.TokenService;
import com.af.v4.system.common.security.utils.SecurityUtils;

public class AuthLogic {
    public final TokenService tokenService = (TokenService)SpringUtils.getBean(TokenService.class);

    public void logout() {
        String token = SecurityUtils.getToken();
        if (token == null) {
            return;
        }
        this.logoutByToken(token);
    }

    public void logoutByToken(String token) {
        this.tokenService.delLoginUser(token);
    }

    public void checkLogin() {
        this.getLoginUser();
    }

    public LoginUser getLoginUser() {
        String token = SecurityUtils.getToken();
        if (token == null) {
            throw new NotLoginException("\u672a\u63d0\u4f9btoken");
        }
        LoginUser loginUser = SecurityUtils.getLoginUser();
        if (loginUser == null) {
            throw new NotLoginException("\u65e0\u6548\u7684token");
        }
        return loginUser;
    }

    public LoginUser getLoginUser(String token) {
        return this.tokenService.getLoginUser(token);
    }

    public void verifyLoginUserExpire(LoginUser loginUser) {
        this.tokenService.verifyToken(loginUser);
    }

    public void checkByAnnotation() {
        this.checkLogin();
    }
}

