/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.security.service;

import com.af.v4.system.api.model.LoginUser;
import com.af.v4.system.common.core.utils.JwtUtils;
import com.af.v4.system.common.core.utils.ServletUtils;
import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.core.utils.ip.IpUtils;
import com.af.v4.system.common.core.utils.uuid.IdUtils;
import com.af.v4.system.common.redis.RedisService;
import com.af.v4.system.common.security.utils.SecurityUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

@Component
public class TokenService {
    protected static final long MILLIS_SECOND = 1000L;
    protected static final long MILLIS_MINUTE = 60000L;
    private static final Long MILLIS_MINUTE_TEN = 0x6DDD00L;
    private static final long EXPIRE_TIME = 720L;
    private static final String ACCESS_TOKEN = "login_tokens:";
    private final RedisService redisService;

    public TokenService(RedisService redisService) {
        this.redisService = redisService;
    }

    public Map<String, Object> createToken(LoginUser loginUser) {
        String token = IdUtils.fastUUID();
        Long userId = loginUser.getSysUser().getUserId();
        String userName = loginUser.getSysUser().getUserName();
        loginUser.setToken(token);
        loginUser.setUserid(userId);
        loginUser.setUsername(userName);
        loginUser.setIpaddr(IpUtils.getIpAddr());
        this.refreshToken(loginUser);
        HashMap<String, Object> claimsMap = new HashMap<String, Object>(3);
        claimsMap.put("user_key", token);
        claimsMap.put("id", userId);
        claimsMap.put("f_username", userName);
        HashMap<String, Object> rspMap = new HashMap<String, Object>(2);
        rspMap.put("access_token", JwtUtils.createToken(claimsMap));
        rspMap.put("expires_in", 720L);
        rspMap.put("resources", loginUser.getResources());
        return rspMap;
    }

    public LoginUser getLoginUser() {
        return this.getLoginUser(ServletUtils.getRequest());
    }

    public void setLoginUser(LoginUser loginUser) {
        if (StringUtils.isNotNull((Object)loginUser) && StringUtils.isNotEmpty((String)loginUser.getToken())) {
            this.refreshToken(loginUser);
        }
    }

    public LoginUser getLoginUser(HttpServletRequest request) {
        String token = SecurityUtils.getToken(request);
        return this.getLoginUser(token);
    }

    public LoginUser getLoginUser(String token) {
        if (StringUtils.isNotEmpty((String)token)) {
            String userKey = JwtUtils.getUserKey((String)token);
            return (LoginUser)this.redisService.get(this.getTokenKey(userKey));
        }
        return null;
    }

    public void delLoginUser(String token) {
        if (StringUtils.isNotEmpty((String)token)) {
            String userKey = JwtUtils.getUserKey((String)token);
            this.redisService.delete(this.getTokenKey(userKey));
        }
    }

    public void verifyToken(LoginUser loginUser) {
        long currentTime;
        long expireTime = loginUser.getExpireTime();
        if (expireTime - (currentTime = System.currentTimeMillis()) <= MILLIS_MINUTE_TEN) {
            this.refreshToken(loginUser);
        }
    }

    public void refreshToken(LoginUser loginUser) {
        loginUser.setLoginTime(Long.valueOf(System.currentTimeMillis()));
        loginUser.setExpireTime(Long.valueOf(loginUser.getLoginTime() + 43200000L));
        String userKey = this.getTokenKey(loginUser.getToken());
        this.redisService.set(userKey, (Object)loginUser, 43200L);
    }

    private String getTokenKey(String token) {
        return ACCESS_TOKEN + token;
    }
}

