/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.security.interceptor;

import com.af.v4.system.api.model.LoginUser;
import com.af.v4.system.common.core.context.SecurityContextHolder;
import com.af.v4.system.common.core.utils.ServletUtils;
import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.security.auth.AuthUtil;
import com.af.v4.system.common.security.utils.SecurityUtils;
import io.jsonwebtoken.JwtException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.AsyncHandlerInterceptor;

public class HeaderInterceptor
implements AsyncHandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeaderInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        SecurityContextHolder.setUserId((String)ServletUtils.getHeader((HttpServletRequest)request, (String)"id"));
        SecurityContextHolder.setUserName((String)ServletUtils.getHeader((HttpServletRequest)request, (String)"f_username"));
        SecurityContextHolder.setUserKey((String)ServletUtils.getHeader((HttpServletRequest)request, (String)"user_key"));
        String token = SecurityUtils.getToken();
        if (StringUtils.isNotEmpty((String)token)) {
            LoginUser loginUser;
            try {
                loginUser = AuthUtil.getLoginUser(token);
            }
            catch (JwtException e) {
                LOGGER.error("\u6821\u9a8c\u51fa\u9519", (Throwable)e);
                loginUser = null;
            }
            if (StringUtils.isNotNull((Object)loginUser)) {
                AuthUtil.verifyLoginUserExpire(loginUser);
                SecurityContextHolder.set((String)"login_user", (Object)loginUser);
            }
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        SecurityContextHolder.remove();
    }
}

