/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.security.feign;

import com.af.v4.system.common.core.utils.ServletUtils;
import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.core.utils.ip.IpUtils;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class FeignRequestInterceptor
implements RequestInterceptor {
    public void apply(RequestTemplate requestTemplate) {
        HttpServletRequest httpServletRequest = ServletUtils.getRequest();
        if (StringUtils.isNotNull((Object)httpServletRequest)) {
            String authentication;
            String userName;
            Map headers = ServletUtils.getHeaders((HttpServletRequest)httpServletRequest);
            String userId = (String)headers.get("id");
            if (StringUtils.isNotEmpty((String)userId)) {
                requestTemplate.header("id", new String[]{userId});
            }
            if (StringUtils.isNotEmpty((String)(userName = (String)headers.get("f_username")))) {
                requestTemplate.header("f_username", new String[]{userName});
            }
            if (StringUtils.isNotEmpty((String)(authentication = (String)headers.get("authorization")))) {
                requestTemplate.header("authorization", new String[]{authentication});
            }
            requestTemplate.header("X-Forwarded-For", new String[]{IpUtils.getIpAddr()});
        }
    }
}

