/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.security.aspect;

import com.af.v4.system.common.security.annotation.RequiresLogin;
import com.af.v4.system.common.security.auth.AuthUtil;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class PreAuthorizeAspect {
    public static final String POINTCUT_SIGN = " @annotation(com.af.v4.system.common.security.annotation.RequiresLogin)";

    @Pointcut(value=" @annotation(com.af.v4.system.common.security.annotation.RequiresLogin)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        this.checkMethodAnnotation(signature.getMethod());
        return joinPoint.proceed();
    }

    public void checkMethodAnnotation(Method method) {
        RequiresLogin requiresLogin = method.getAnnotation(RequiresLogin.class);
        if (requiresLogin != null) {
            AuthUtil.checkLogin();
        }
    }
}

