/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.security.handler;

import com.af.v4.system.common.core.exception.InnerAuthException;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.core.web.AjaxResult;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public AjaxResult handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("\u8bf7\u6c42\u5730\u5740'{}',\u4e0d\u652f\u6301'{}'\u8bf7\u6c42", (Object)requestURI, (Object)e.getMethod());
        return AjaxResult.error((String)e.getMessage());
    }

    @ExceptionHandler(value={ServiceException.class})
    public AjaxResult handleServiceException(ServiceException e, HttpServletRequest request) {
        Integer code = e.getCode();
        String requestURI = request.getRequestURI();
        if (e.getDetailMessage() != null) {
            log.error("\u8bf7\u6c42\u5730\u5740'{}',\u53d1\u751f\u670d\u52a1\u7aef\u5f02\u5e38.\n {}", (Object)requestURI, (Object)e.getDetailMessage());
        } else {
            log.error("\u8bf7\u6c42\u5730\u5740'{}',\u53d1\u751f\u670d\u52a1\u7aef\u5f02\u5e38.", (Object)requestURI, (Object)e);
        }
        return StringUtils.isNotNull((Object)code) ? AjaxResult.error((int)code, (String)e.getMessage()) : AjaxResult.error((String)e.getMessage());
    }

    @ExceptionHandler(value={RuntimeException.class})
    public AjaxResult handleRuntimeException(RuntimeException e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("\u8bf7\u6c42\u5730\u5740'{}',\u53d1\u751f\u8fd0\u884c\u65f6\u5f02\u5e38.", (Object)requestURI, (Object)e);
        return AjaxResult.error((String)e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public AjaxResult handleException(Exception e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("\u8bf7\u6c42\u5730\u5740'{}',\u53d1\u751f\u7cfb\u7edf\u5f02\u5e38.", (Object)requestURI, (Object)e);
        return AjaxResult.error((String)e.getMessage());
    }

    @ExceptionHandler(value={BindException.class})
    public AjaxResult handleBindException(BindException e) {
        log.error(e.getMessage(), (Throwable)e);
        String message = ((ObjectError)e.getAllErrors().get(0)).getDefaultMessage();
        return AjaxResult.error((String)message);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Object handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        log.error(e.getMessage(), (Throwable)e);
        String message = Objects.requireNonNull(e.getBindingResult().getFieldError()).getDefaultMessage();
        return AjaxResult.error((String)message);
    }

    @ExceptionHandler(value={InnerAuthException.class})
    public AjaxResult handleInnerAuthException(InnerAuthException e) {
        return AjaxResult.error((String)e.getMessage());
    }
}

