/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.core.proxy.liuli.ILiuLiConfigServiceProxy;
import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.resource.enums.ResourceType;
import com.af.v4.system.common.resource.mapper.AbstractResourceMapper;
import com.af.v4.system.common.resource.mapper.ModuleMapper;
import java.util.Map;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class LogicMapper
extends AbstractResourceMapper<LogicResource> {
    private static final Boolean DEFAULT_CACHE_STATE = false;
    private static final Long DEFAULT_CACHE_TIME = 60L;
    private static final Boolean DEFAULT_AUTH_STATE = true;
    private static final Boolean DEFAULT_MOBILE_STATE = false;
    private static final Boolean DEFAULT_CALLBACK_API_STATE = false;
    private static final Boolean DEFAULT_DEPRECATED_STATE = false;

    protected LogicMapper(ModuleMapper moduleMapper, ApplicationService applicationService, ILiuLiConfigServiceProxy liuLiConfigServiceProxy) {
        super(moduleMapper, applicationService, liuLiConfigServiceProxy);
    }

    @Override
    public ResourceType getResType() {
        return ResourceType.LOGIC;
    }

    @Override
    public String getFileName() {
        return "logic.xml";
    }

    @Override
    public String getFolderName() {
        return "logics";
    }

    @Override
    protected LogicResource buildResourceImpl(String moduleName, String key, String path, JSONObject liuliValue, Map<String, Object> attrMap) {
        Object dataSource = attrMap.get("dataSource");
        Object cache = attrMap.get("cache");
        Object cacheKey = attrMap.get("cacheKey");
        Object time = attrMap.get("time");
        Object demoteLogicName = attrMap.get("demoteLogicName");
        Object auth = attrMap.get("auth");
        Object mobile = attrMap.get("mobile");
        Object callbackApi = attrMap.get("callbackApi");
        Object deprecated = attrMap.get("deprecated");
        Object replacedBy = attrMap.get("replacedBy");
        return new LogicResource(this, moduleName, key, path, liuliValue, dataSource == null ? null : dataSource.toString(), cache == null ? DEFAULT_CACHE_STATE : Boolean.parseBoolean(cache.toString()), time == null ? DEFAULT_CACHE_TIME : Long.parseLong(time.toString()), cacheKey == null || cacheKey.toString().isEmpty() ? null : cacheKey.toString(), demoteLogicName == null || demoteLogicName.toString().isEmpty() ? null : demoteLogicName.toString(), auth == null ? DEFAULT_AUTH_STATE : Boolean.parseBoolean(auth.toString()), mobile == null ? DEFAULT_MOBILE_STATE : Boolean.parseBoolean(mobile.toString()), callbackApi == null ? DEFAULT_CALLBACK_API_STATE : Boolean.parseBoolean(callbackApi.toString()), deprecated == null ? DEFAULT_DEPRECATED_STATE : Boolean.parseBoolean(deprecated.toString()), replacedBy == null ? null : replacedBy.toString());
    }

    public static class LogicResource
    extends AbstractResourceMapper.CommonResource
    implements AbstractResourceMapper.MobileResourceSupport,
    AbstractResourceMapper.DataSourceResourceSupport {
        private final String dataSource;
        private final boolean cache;
        private final long time;
        private final String cacheKey;
        private final String demoteLogicName;
        private final boolean auth;
        private final boolean mobile;
        private final boolean callbackApi;
        private final boolean deprecated;
        private final String replacedBy;

        public LogicResource(AbstractResourceMapper<?> mapper, String moduleName, String key, String path, JSONObject liuliValue, String dataSource, Boolean cache, Long time, String cacheKey, String demoteLogicName, Boolean auth, Boolean mobile, Boolean callbackApi, Boolean deprecated, String replacedBy) {
            super(mapper, moduleName, key, path, liuliValue);
            this.dataSource = dataSource;
            this.cache = cache;
            this.time = time;
            this.cacheKey = cacheKey;
            this.demoteLogicName = demoteLogicName;
            this.auth = auth;
            this.mobile = mobile;
            this.callbackApi = callbackApi;
            this.deprecated = deprecated;
            this.replacedBy = replacedBy;
        }

        @Override
        public String getDataSource() {
            return this.dataSource;
        }

        public boolean isCache() {
            return this.cache;
        }

        public long getTime() {
            return this.time;
        }

        public String getCacheKey() {
            return this.cacheKey;
        }

        public String getDemoteLogicName() {
            return this.demoteLogicName;
        }

        public boolean getAuth() {
            return this.auth;
        }

        @Override
        public boolean isMobile() {
            return this.mobile;
        }

        public boolean isCallbackApi() {
            return this.callbackApi;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public String getReplacedBy() {
            return this.replacedBy;
        }
    }
}

