package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.core.proxy.liuli.ILiuLiConfigServiceProxy;
import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.resource.enums.ResourceType;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * logic映射器
 *
 * @author Mr.river
 */
@Component
public class LogicMapper extends AbstractResourceMapper<LogicMapper.LogicResource> {

    private static final Boolean DEFAULT_CACHE_STATE = false;
    private static final Long DEFAULT_CACHE_TIME = 60L;
    private static final Boolean DEFAULT_AUTH_STATE = true;
    private static final Boolean DEFAULT_MOBILE_STATE = false;
    private static final Boolean DEFAULT_CALLBACK_API_STATE = false;
    private static final Boolean DEFAULT_DEPRECATED_STATE = false;

    protected LogicMapper(ModuleMapper moduleMapper, ApplicationService applicationService, ILiuLiConfigServiceProxy liuLiConfigServiceProxy) {
        super(moduleMapper, applicationService, liuLiConfigServiceProxy);
    }

    @Override
    public ResourceType getResType() {
        return ResourceType.LOGIC;
    }

    @Override
    public String getFileName() {
        return "logic.xml";
    }

    @Override
    public String getFolderName() {
        return "logics";
    }

    @Override
    protected LogicResource buildResourceImpl(String moduleName, String key, String path, JSONObject liuliValue, Map<String, Object> attrMap) {
        // 所属数据源
        Object dataSource = attrMap.get("dataSource");
        // 是否缓存
        Object cache = attrMap.get("cache");
        // 自定义缓存Key
        Object cacheKey = attrMap.get("cacheKey");
        // 缓存时间
        Object time = attrMap.get("time");
        // 业务降级Logic名称
        Object demoteLogicName = attrMap.get("demoteLogicName");
        // 是否鉴权
        Object auth = attrMap.get("auth");
        // 是否支持手机端
        Object mobile = attrMap.get("mobile");
        // 是否为第三方回调接口
        Object callbackApi = attrMap.get("callbackApi");
        // 标记过时
        Object deprecated = attrMap.get("deprecated");
        // 替代接口名
        Object replacedBy = attrMap.get("replacedBy");

        return new LogicResource(
                this,
                moduleName,
                key,
                path,
                liuliValue,
                dataSource == null ? null : dataSource.toString(),
                cache == null ? DEFAULT_CACHE_STATE : Boolean.parseBoolean(cache.toString()),
                time == null ? DEFAULT_CACHE_TIME : Long.parseLong(time.toString()),
                cacheKey == null || cacheKey.toString().isEmpty() ? null : cacheKey.toString(),
                demoteLogicName == null || demoteLogicName.toString().isEmpty() ? null : demoteLogicName.toString(),
                auth == null ? DEFAULT_AUTH_STATE : Boolean.parseBoolean(auth.toString()),
                mobile == null ? DEFAULT_MOBILE_STATE : Boolean.parseBoolean(mobile.toString()),
                callbackApi == null ? DEFAULT_CALLBACK_API_STATE : Boolean.parseBoolean(callbackApi.toString()),
                deprecated == null ? DEFAULT_DEPRECATED_STATE : Boolean.parseBoolean(deprecated.toString()),
                replacedBy == null ? null : replacedBy.toString()
        );
    }

    /**
     * Logic资源
     */
    public static class LogicResource extends AbstractResourceMapper.CommonResource implements MobileResourceSupport, DataSourceResourceSupport {
        /**
         * 所属数据源
         */
        private final String dataSource;
        /**
         * 是否缓存
         */
        private final boolean cache;
        /**
         * 缓存时间
         */
        private final long time;
        /**
         * 自定义缓存Key
         */
        private final String cacheKey;
        /**
         * 业务降级Logic名称
         */
        private final String demoteLogicName;
        /**
         * 是否鉴权
         */
        private final boolean auth;
        /**
         * 是否支持手机端
         */
        private final boolean mobile;
        /**
         * 是否为第三方回调接口，该值为是时，响应体不进行统一封装处理
         */
        private final boolean callbackApi;
        /**
         * 标记接口过时
         */
        private final boolean deprecated;
        /**
         * 过时接口的替代接口名
         */
        private final String replacedBy;

        public LogicResource(AbstractResourceMapper<?> mapper, String moduleName, String key, String path, JSONObject liuliValue, String dataSource, Boolean cache, Long time,
                             String cacheKey, String demoteLogicName, Boolean auth, Boolean mobile, Boolean callbackApi, Boolean deprecated, String replacedBy) {
            super(mapper, moduleName, key, path, liuliValue);
            this.dataSource = dataSource;
            this.cache = cache;
            this.time = time;
            this.cacheKey = cacheKey;
            this.demoteLogicName = demoteLogicName;
            this.auth = auth;
            this.mobile = mobile;
            this.callbackApi = callbackApi;
            this.deprecated = deprecated;
            this.replacedBy = replacedBy;
        }

        public String getDataSource() {
            return dataSource;
        }

        public boolean isCache() {
            return cache;
        }

        public long getTime() {
            return time;
        }

        public String getCacheKey() {
            return cacheKey;
        }

        public String getDemoteLogicName() {
            return demoteLogicName;
        }

        public boolean getAuth() {
            return auth;
        }

        public boolean isMobile() {
            return mobile;
        }

        public boolean isCallbackApi() {
            return callbackApi;
        }

        public boolean isDeprecated() {
            return deprecated;
        }

        public String getReplacedBy() {
            return replacedBy;
        }
    }
}
