package com.af.v4.system.common.resource.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;

/**
 * 静态资源配置
 *
 * @author Mr.river
 */
@RefreshScope  // 添加此注解支持配置动态刷新
@Configuration
@ConfigurationProperties(prefix = "resource")
public class ResourceConfig {
    /**
     * 资源根路径
     */
    private String fileRootPath;

    /**
     * 资源上传模式(ResUploadModeEnum)，默认server
     */
    private String resUploadMode = "server";

    public String getFileRootPath() {
        return fileRootPath;
    }

    public void setFileRootPath(String fileRootPath) {
        this.fileRootPath = fileRootPath;
    }

    public String getResUploadMode() {
        return resUploadMode;
    }

    public void setResUploadMode(String resUploadMode) {
        this.resUploadMode = resUploadMode;
    }
}
