/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.resource.config.ResourceConfig;
import com.af.v4.system.common.resource.mapper.AbstractResourceMapper;
import com.af.v4.system.common.resource.mapper.ModuleMapper;
import java.util.Map;
import org.dom4j.Element;
import org.springframework.stereotype.Component;

@Component
public class LogicMapper
extends AbstractResourceMapper<String> {
    protected LogicMapper(ModuleMapper moduleMapper, ResourceConfig resourceConfig) {
        super(moduleMapper, resourceConfig);
    }

    @Override
    protected String getResType() {
        return "logic";
    }

    @Override
    protected String getFileName() {
        return "logic.xml";
    }

    @Override
    protected String getFolderName() {
        return "logics";
    }

    @Override
    protected Map<String, String> appendRes(Element element, String moduleName, String parentModuleName) {
        Map<String, String> res = super.appendRes(element, moduleName, parentModuleName);
        String log = element.attributeValue("log");
        String mobile = element.attributeValue("mobile");
        String dataSource = element.attributeValue("dataSource");
        String cache = element.attributeValue("cache");
        String time = element.attributeValue("time");
        String cacheKey = element.attributeValue("cacheKey");
        res.put("log", log);
        res.put("mobile", mobile);
        res.put("dataSource", dataSource);
        res.put("cache", cache);
        res.put("cacheKey", cacheKey);
        res.put("time", time);
        return res;
    }

    @Override
    public LogicResource<String> getValue(String key) {
        String alias = super.getAlias(key);
        Map res = (Map)this.map.get(alias);
        if (this.map.containsKey(alias)) {
            return new LogicResource<String>(alias, (String)res.get("value"), (String)res.get("cache"), (String)res.get("time"), (String)res.get("cacheKey"));
        }
        return new LogicResource<Object>(alias, null, null, null, null);
    }

    public static class LogicResource<T>
    extends AbstractResourceMapper.CommonResource<T> {
        private final boolean cache;
        private final long time;
        private final String cacheKey;

        LogicResource(String alias, T path, String cache, String time, String cacheKey) {
            super(alias, path);
            this.cache = Boolean.parseBoolean(cache);
            this.time = time != null ? Long.parseLong(time) : -1L;
            this.cacheKey = cacheKey;
        }

        public boolean getCache() {
            return this.cache;
        }

        public long getTime() {
            return this.time;
        }

        public String getCacheKey() {
            return this.cacheKey;
        }
    }
}

