/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.plugins.io.IOTools;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ModuleMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleMapper.class);
    private static final String MODULE_FILE_NAME = "module.xml";
    private static final String MODE_NAME = "module";
    private static final String IMPORT_NAME = "import";
    private static Map<String, Map<String, String>> map;

    public ModuleMapper() {
        this.loadMap();
    }

    public Map<String, Map<String, String>> getMap() {
        return map;
    }

    private void loadModuleFile(String path, boolean isRoot) {
        if (!isRoot && !IOTools.hasResource((String)path)) {
            return;
        }
        IOTools.getStream((String)path, stream -> {
            try {
                this.parseModule(stream);
            }
            catch (DocumentException e) {
                throw new RuntimeException(e);
            }
        }, errorPath -> {
            throw new ServiceException("\u9879\u76ee\u6839\u8def\u5f84\u6a21\u5757\u5b9a\u4e49\u6587\u4ef6[module.xml]\u672a\u627e\u5230\uff0c\u76f8\u5173\u8def\u5f84\uff1a" + errorPath, Integer.valueOf(506));
        });
    }

    private void loadMap() {
        map = new LinkedHashMap<String, Map<String, String>>();
        this.loadModuleFile(MODULE_FILE_NAME, true);
    }

    private void parseModule(InputStream stream) throws DocumentException {
        String name;
        Element elm;
        File directory;
        File[] directoryList;
        SAXReader reader = new SAXReader();
        Document document = reader.read(stream);
        Element root = document.getRootElement();
        URL url = ModuleMapper.class.getResource("/organizations/");
        if (url != null && (directoryList = (directory = new File(url.getPath())).listFiles()) != null) {
            for (File item : directoryList) {
                if (!item.isDirectory()) continue;
                String name2 = item.getName();
                HashMap<String, String> module = new HashMap<String, String>(3);
                module.put("name", name2);
                module.put("path", "organizations");
                map.put(name2, module);
                LOGGER.info("\u7ec4\u7ec7\u673a\u6784\u6a21\u5757\uff1a[" + name2 + "]\u52a0\u8f7d\u5b8c\u6210");
            }
        }
        Iterator ite = root.elementIterator(IMPORT_NAME);
        while (ite.hasNext()) {
            elm = (Element)ite.next();
            name = elm.attribute("name").getValue();
            LOGGER.info("====\u4ece\u6a21\u5757\u96c6[" + name + "]\u5bfc\u5165\u6a21\u5757====");
            this.loadModuleFile(name + "/module.xml", false);
            LOGGER.info("====\u4ece\u9ed8\u8ba4\u76ee\u5f55\u5bfc\u5165\u6a21\u5757====");
        }
        Iterator it = root.elementIterator(MODE_NAME);
        while (it.hasNext()) {
            elm = (Element)it.next();
            name = elm.attribute("name").getValue();
            String upload = elm.attributeValue("upload");
            String path = elm.attributeValue("path");
            HashMap<String, String> module = new HashMap<String, String>(3);
            module.put("name", name);
            module.put("upload", upload);
            module.put("path", path);
            map.put(name, module);
            LOGGER.info("\u6a21\u5757\uff1a[" + name + "]\u52a0\u8f7d\u5b8c\u6210");
        }
    }
}

