/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.plugins.io.IOTools;
import com.af.v4.system.common.resource.config.ResourceConfig;
import com.af.v4.system.common.resource.mapper.ModuleMapper;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RestController;

@Component
public abstract class AbstractResourceMapper<T> {
    public static final String ORGANIZATIONAL_DIRECTORY_NAME = "organizations";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractResourceMapper.class);
    private static String VERSION_ALIAS;
    private final ModuleMapper moduleMapper;
    protected Map<String, Map<String, T>> map;

    protected AbstractResourceMapper(ModuleMapper moduleMapper, ResourceConfig resourceConfig) {
        this.moduleMapper = moduleMapper;
        VERSION_ALIAS = Optional.ofNullable(resourceConfig.getVersionAlias()).orElse("standard");
    }

    public static String getVersionAliasValue() {
        return VERSION_ALIAS;
    }

    protected abstract String getResType();

    protected abstract String getFileName();

    protected abstract String getFolderName();

    @PostConstruct
    protected void loadMap() {
        if (this.map == null) {
            this.map = new HashMap<String, Map<String, T>>(36);
            this.putMapByRoot();
            this.moduleMapper.getMap().forEach((key, value) -> {
                String name = (String)value.get("name");
                String path = (String)value.get("path");
                try {
                    this.putMapByModule(name, path);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    protected void putMapByRoot() {
        this.putMapByModule(null, null);
    }

    protected void putMapByModule(String name, String parent) {
        String fileName = this.getFileName();
        String resType = this.getResType();
        Object str = parent == null ? (name == null ? fileName : name + "/" + fileName) : parent + "/" + name + "/" + fileName;
        IOTools.getStream((String)str, stream -> {
            Document document;
            SAXReader reader = new SAXReader();
            try {
                document = reader.read(stream);
            }
            catch (DocumentException e) {
                throw new RuntimeException(e);
            }
            Element root = document.getRootElement();
            Iterator item = root.elementIterator(resType);
            while (item.hasNext()) {
                Element element = (Element)item.next();
                this.appendRes(element, name, parent);
            }
        });
    }

    public Map<String, Map<String, T>> getAllMap() {
        return this.map;
    }

    public CommonResource<T> getValue(String key) {
        String alias = this.getAlias(key);
        if (this.map.containsKey(alias)) {
            return new CommonResource<T>(alias, this.map.get(alias).get("value"));
        }
        return new CommonResource<Object>(alias, null);
    }

    protected String getAlias(String key) {
        String versionAliasValue = AbstractResourceMapper.getVersionAliasValue();
        if (versionAliasValue.equals("standard")) {
            return key;
        }
        String alias = key + "@" + versionAliasValue;
        return this.map.containsKey(alias) ? alias : key;
    }

    public Map<String, T> getRes(String key) {
        String alias = this.getAlias(key);
        return this.map.getOrDefault(alias, null);
    }

    protected Map<String, T> appendRes(Element element, String moduleName, String parentModuleName) {
        Object value;
        Object alias = element.attribute("alias").getValue();
        if (Objects.equals(parentModuleName, ORGANIZATIONAL_DIRECTORY_NAME)) {
            alias = (String)alias + "@" + moduleName;
        }
        if (this.map.containsKey(alias)) {
            String resType = this.getResType();
            throw new ServiceException(resType + "\u522b\u540d[" + (String)alias + "]\u5df2\u5b58\u5728", Integer.valueOf(506));
        }
        HashMap<String, Object> res = new HashMap<String, Object>(4);
        Attribute pathAttribute = element.attribute("path");
        if (pathAttribute != null) {
            Object path = pathAttribute.getValue();
            String folderName = this.getFolderName();
            value = path = (parentModuleName == null ? moduleName + "/" + folderName + "/" : parentModuleName + "/" + moduleName + "/" + folderName + "/") + (String)path;
        } else {
            Object obj;
            String className = element.attribute("class").getValue();
            value = obj = this.getClassByName(className, moduleName);
        }
        if (value != null) {
            res.put("alias", alias);
            res.put("value", value);
            this.map.put((String)alias, res);
        }
        return res;
    }

    private Object getClassByName(String className, String moduleName) {
        try {
            Class<?> c = Class.forName(className);
            Object obj = this.isSpringBean(c) ? SpringUtils.getBean(c) : c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return obj;
        }
        catch (ClassNotFoundException | NoClassDefFoundError ex) {
            LOGGER.warn("\u672a\u627e\u5230\u7c7b, \u6a21\u5757=" + moduleName + ", \u7c7b=" + ex.getMessage());
            return null;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private boolean isSpringBean(Class<?> c) {
        for (Annotation annotation : c.getAnnotations()) {
            if (annotation.annotationType() != Component.class && annotation.annotationType() != Service.class && annotation.annotationType() != RestController.class) continue;
            return true;
        }
        return false;
    }

    public static class CommonResource<T> {
        private final String alias;
        private final T path;

        CommonResource(String alias, T path) {
            this.alias = alias;
            this.path = path;
        }

        public String getAlias() {
            return this.alias;
        }

        public T getPath() {
            return this.path;
        }
    }
}

