package com.af.v4.system.common.resource.enums;

import java.util.stream.Stream;

/**
 * 兼容版本
 *
 * @author Mr.river
 */
public enum CompatibleVersion {
    /**
     * V2，最显著特征是t_userfiles表的主键为f_user_id
     */
    V2("V2"),
    /**
     * V3
     */
    V3("V3"),
    /**
     * 从不
     */
    NEVER("never");

    private final String value;

    CompatibleVersion(String value) {
        this.value = value;
    }

    public static CompatibleVersion toType(String value) {
        return Stream.of(CompatibleVersion.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(NEVER);
    }

    public static boolean is(String value) {
        return toType(value) != null;
    }

    public String getValue() {
        return value;
    }
}
