package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.resource.config.ResourceConfig;
import org.dom4j.Element;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * prompt映射器
 *
 * @author Mr.river
 */
@Component
public class PromptMapper extends AbstractResourceMapper<String> {
    protected PromptMapper(ModuleMapper moduleMapper, ResourceConfig resourceConfig) {
        super(moduleMapper, resourceConfig);
    }

    @Override
    protected String getResType() {
        return "prompt";
    }

    @Override
    protected String getFileName() {
        return "prompt.xml";
    }

    @Override
    protected String getFolderName() {
        return "prompts";
    }

    @Override
    protected Map<String, String> appendRes(Element element, String moduleName, String parentModuleName) {
        return super.appendRes(element, moduleName, parentModuleName);
    }
}
