package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.resource.config.ResourceConfig;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.stream.Collectors;

/**
 * 业务插件映射器
 *
 * @author Mr.river
 */
@Component
public class PluginMapper extends AbstractResourceMapper<Object> {

    public static Map<String, Object> pluginMap;

    protected PluginMapper(ModuleMapper moduleMapper, ResourceConfig resourceConfig) {
        super(moduleMapper, resourceConfig);
    }

    @Override
    protected void loadMap() {
        super.loadMap();
        pluginMap = getAllMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, object -> object.getValue().get("value")));
    }

    @Override
    protected String getResType() {
        return "plugin";
    }

    @Override
    protected String getFileName() {
        return "plugins.xml";
    }

    @Override
    protected String getFolderName() {
        return null;
    }
}
