package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.core.constant.HttpStatus;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.plugins.io.IOTools;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 模块映射器
 *
 * @author Mr.river
 */
@Component
public class ModuleMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleMapper.class);

    /**
     * 模块映射文件名称
     */
    private static final String MODULE_FILE_NAME = "module.xml";

    /**
     * 模块属性：名称
     */
    private static final String MODE_NAME = "module";

    private static Map<String, Map<String, String>> map;

    {
        loadMap();
    }

    /**
     * 获取所有模块映射文件
     */
    public Map<String, Map<String, String>> getMap() {
        return map;
    }

    private void loadMap() {
        map = new LinkedHashMap<>();
        IOTools.getStream(MODULE_FILE_NAME, stream -> {
            try {
                parseModule(stream);
            } catch (DocumentException e) {
                throw new RuntimeException(e);
            }
        }, errorPath -> {
            throw new ServiceException("模块定义文件module.xml未找到，相关路径：" + errorPath, HttpStatus.CONFIG_ERROR);
        });
    }


    private void parseModule(InputStream stream) throws DocumentException {
        SAXReader reader = new SAXReader();
        Document document = reader.read(stream);
        Element root = document.getRootElement();
        // 遍历组织机构模块
        URL url = ModuleMapper.class.getResource("/" + AbstractResourceMapper.ORGANIZATIONAL_DIRECTORY_NAME + "/");
        if (url != null) {
            File directory = new File(url.getPath());
            File[] directoryList = directory.listFiles();
            if (directoryList != null) {
                for (File item : directoryList) {
                    if (item.isDirectory()) {
                        String name = item.getName();
                        // 设置module属性
                        Map<String, String> module = new HashMap<>(3);
                        module.put("name", name);
                        module.put("path", AbstractResourceMapper.ORGANIZATIONAL_DIRECTORY_NAME);
                        map.put(name, module);
                        LOGGER.info("组织机构模块：[" + name + "]加载完成");
                    }
                }
            }
        }
        for (Iterator<Element> it = root.elementIterator(MODE_NAME); it.hasNext(); ) {
            Element elm = it.next();
            String name = elm.attribute("name").getValue();
            String upload = elm.attributeValue("upload");
            String path = elm.attributeValue("path");
            // 设置module属性
            Map<String, String> module = new HashMap<>(3);
            module.put("name", name);
            module.put("upload", upload);
            module.put("path", path);
            map.put(name, module);
            LOGGER.info("模块：[" + name + "]加载完成");
        }
    }
}
