package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.resource.config.ResourceConfig;
import org.dom4j.Element;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * logic映射器
 *
 * @author Mr.river
 */
@Component
public class LogicMapper extends AbstractResourceMapper<String> {
    protected LogicMapper(ModuleMapper moduleMapper, ResourceConfig resourceConfig) {
        super(moduleMapper, resourceConfig);
    }

    @Override
    protected String getResType() {
        return "logic";
    }

    @Override
    protected String getFileName() {
        return "logic.xml";
    }

    @Override
    protected String getFolderName() {
        return "logics";
    }

    @Override
    protected Map<String, String> appendRes(Element element, String moduleName, String parentModuleName) {
        Map<String, String> res = super.appendRes(element, moduleName, parentModuleName);
        // 追加元素
        String log = element.attributeValue("log");
        String mobile = element.attributeValue("mobile");
        // 执行数据源
        String dataSource = element.attributeValue("dataSource");
        // 是否缓存
        String cache = element.attributeValue("cache");
        // 缓存时间
        String time = element.attributeValue("time");
        // 自定义缓存Key
        String cacheKey = element.attributeValue("cacheKey");
        res.put("log", log);
        res.put("mobile", mobile);
        res.put("dataSource", dataSource);
        res.put("cache", cache);
        res.put("cacheKey", cacheKey);
        res.put("time", time);
        return res;
    }

    /**
     * 根据Key获取值
     *
     * @param key KEY
     * @return value
     */
    public LogicResource<String> getValue(String key) {
        String alias = super.getAlias(key);
        Map<String, String> res = map.get(alias);
        if (map.containsKey(alias)) {
            return new LogicResource<>(alias, res.get("value"), res.get("cache"), res.get("time"), res.get("cacheKey"));
        }
        return new LogicResource<>(alias, null, null, null, null);
    }

    /**
     * 资源结果集
     *
     * @param <T> 资源数据类型
     */
    public static class LogicResource<T> extends CommonResource<T> {
        /**
         * 是否缓存
         */
        private final boolean cache;
        /**
         * 缓存时间
         */
        private final long time;
        /**
         * 自定义缓存Key
         */
        private final String cacheKey;

        LogicResource(String alias, T path, String cache, String time, String cacheKey) {
            super(alias, path);
            this.cache = Boolean.parseBoolean(cache);
            this.time = time != null ? Long.parseLong(time) : -1L;
            this.cacheKey = cacheKey;
        }


        public boolean getCache() {
            return cache;
        }

        public long getTime() {
            return time;
        }

        public String getCacheKey() {
            return cacheKey;
        }
    }
}
