/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.plugins.io.IOTools;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ModuleMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleMapper.class);
    private static final String MODULE_FILE_NAME = "module.xml";
    private static final String MODE_NAME = "module";
    private static Map<String, Map<String, String>> map;

    public ModuleMapper() {
        this.loadMap();
    }

    public Map<String, Map<String, String>> getMap() {
        return map;
    }

    private void loadMap() {
        map = new LinkedHashMap<String, Map<String, String>>();
        IOTools.getStream((String)MODULE_FILE_NAME, stream -> {
            try {
                this.parseModule(stream);
            }
            catch (DocumentException e) {
                throw new RuntimeException(e);
            }
        }, errorPath -> {
            throw new ServiceException("\u6a21\u5757\u5b9a\u4e49\u6587\u4ef6module.xml\u672a\u627e\u5230\uff0c\u76f8\u5173\u8def\u5f84\uff1a" + errorPath);
        });
    }

    private void parseModule(InputStream stream) throws DocumentException {
        File directory;
        File[] directoryList;
        SAXReader reader = new SAXReader();
        Document document = reader.read(stream);
        Element root = document.getRootElement();
        URL url = ModuleMapper.class.getResource("/organizations/");
        if (url != null && (directoryList = (directory = new File(url.getPath())).listFiles()) != null) {
            for (File item : directoryList) {
                if (!item.isDirectory()) continue;
                String name = item.getName();
                HashMap<String, String> module = new HashMap<String, String>(3);
                module.put("name", name);
                module.put("path", "organizations");
                map.put(name, module);
                LOGGER.info("\u7ec4\u7ec7\u673a\u6784\u6a21\u5757\uff1a[" + name + "]\u52a0\u8f7d\u5b8c\u6210");
            }
        }
        Iterator it = root.elementIterator(MODE_NAME);
        while (it.hasNext()) {
            Element elm = (Element)it.next();
            String name = elm.attribute("name").getValue();
            String upload = elm.attributeValue("upload");
            String path = elm.attributeValue("path");
            HashMap<String, String> module = new HashMap<String, String>(3);
            module.put("name", name);
            module.put("upload", upload);
            module.put("path", path);
            map.put(name, module);
            LOGGER.info("\u6a21\u5757\uff1a[" + name + "]\u52a0\u8f7d\u5b8c\u6210");
        }
    }
}

