package com.af.v4.system.common.resource.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * 静态资源配置
 *
 * @author Mr.river
 */
@Configuration
@ConfigurationProperties(prefix = "resource")
public class ResourceConfig {
    /**
     * 系统定制版本值
     */
    private String versionAlias;
    /**
     * 资源根路径
     */
    private String fileRootPath;

    /**
     * 扩展路径
     */
    private String extraPaths;

    public String getFileRootPath() {
        return fileRootPath;
    }

    public void setFileRootPath(String fileRootPath) {
        this.fileRootPath = fileRootPath;
    }

    public String getExtraPaths() {
        return extraPaths;
    }

    public void setExtraPaths(String extraPaths) {
        this.extraPaths = extraPaths;
    }

    public String getVersionAlias() {
        return versionAlias;
    }

    public void setVersionAlias(String versionAlias) {
        this.versionAlias = versionAlias;
    }
}
