/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.datasource.enums.DbType;
import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.resource.enums.ResourceType;
import com.af.v4.system.common.resource.mapper.AbstractResourceMapper;
import com.af.v4.system.common.resource.mapper.ModuleMapper;
import java.util.Map;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class SqlMapper
extends AbstractResourceMapper<SqlResource> {
    private static final Boolean DEFAULT_MOBILE_STATE = false;

    protected SqlMapper(ModuleMapper moduleMapper, ApplicationUtils applicationUtils, LiuLiConfigService liuLiConfigService) {
        super(moduleMapper, applicationUtils, liuLiConfigService);
    }

    @Override
    public ResourceType getResType() {
        return ResourceType.SQL;
    }

    @Override
    public String getFileName() {
        return "sql.xml";
    }

    @Override
    public String getFolderName() {
        return "sqls";
    }

    @Override
    protected SqlResource buildResourceImpl(String moduleName, String key, String path, JSONObject liuliValue, Map<String, Object> attrMap) {
        Object dataSource = attrMap.get("dataSource");
        Object mobile = attrMap.get("mobile");
        return new SqlResource(this, moduleName, key, path, liuliValue, dataSource == null ? null : dataSource.toString(), mobile == null ? DEFAULT_MOBILE_STATE : Boolean.parseBoolean(mobile.toString()));
    }

    @Override
    protected String rewriteSource(String source) {
        if (((String)(source = "$" + (String)source)).contains("${")) {
            source = ((String)source).replace("${", "{");
        }
        return source;
    }

    @Override
    protected String[] getCandidateAliasList(String key) {
        String alias;
        DbType dbType = DynamicDataSource.getDbType();
        switch (dbType) {
            case oracle: {
                String string = key + "_oracle";
                break;
            }
            case mysql: {
                String string = key + "_mysql";
                break;
            }
            default: {
                String string = alias = null;
            }
        }
        if (alias != null) {
            return new String[]{alias, key};
        }
        return new String[]{key};
    }

    public static class SqlResource
    extends AbstractResourceMapper.CommonResource
    implements AbstractResourceMapper.MobileResourceSupport,
    AbstractResourceMapper.DataSourceResourceSupport {
        private final String dataSource;
        private final boolean mobile;

        public SqlResource(AbstractResourceMapper<?> mapper, String moduleName, String key, String path, JSONObject liuliValue, String dataSource, Boolean mobile) {
            super(mapper, moduleName, key, path, liuliValue);
            this.dataSource = dataSource;
            this.mobile = mobile;
        }

        @Override
        public String getDataSource() {
            return this.dataSource;
        }

        @Override
        public boolean isMobile() {
            return this.mobile;
        }
    }
}

