package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.resource.enums.ResourceType;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 报表映射器
 *
 * @author Mr.river
 */
@Component
public class ReportMapper extends AbstractResourceMapper<ReportMapper.ReportResource> {

    private static final Boolean DEFAULT_MOBILE_STATE = false;

    protected ReportMapper(ModuleMapper moduleMapper, ApplicationUtils applicationUtils, LiuLiConfigService liuLiConfigService) {
        super(moduleMapper, applicationUtils, liuLiConfigService);
    }


    @Override
    public ResourceType getResType() {
        return ResourceType.REPORT;
    }

    @Override
    public String getFileName() {
        return "report.xml";
    }

    @Override
    public String getFolderName() {
        return "reports";
    }

    @Override
    protected ReportMapper.ReportResource buildResourceImpl(String moduleName, String key, String path, JSONObject liuliValue, Map<String, Object> attrMap) {
        // 所属数据源
        Object dataSource = attrMap.get("dataSource");
        // 是否支持手机端
        Object mobile = attrMap.get("mobile");

        return new ReportMapper.ReportResource(
                this,
                moduleName,
                key,
                path,
                liuliValue,
                dataSource == null ? null : dataSource.toString(),
                mobile == null ? DEFAULT_MOBILE_STATE : Boolean.parseBoolean(mobile.toString()));
    }

    @Override
    public boolean isSupportCompile() {
        return false;
    }

    /**
     * Report资源
     */
    public static class ReportResource extends CommonResource implements MobileResourceSupport, DataSourceResourceSupport {
        /**
         * 所属数据源
         */
        private final String dataSource;
        /**
         * 是否支持手机端
         */
        private final boolean mobile;

        public ReportResource(AbstractResourceMapper<?> mapper, String moduleName, String key, String path, JSONObject liuliValue, String dataSource, Boolean mobile) {
            super(mapper, moduleName, key, path, liuliValue);
            this.dataSource = dataSource;
            this.mobile = mobile;
        }

        @Override
        public String getDataSource() {
            return dataSource;
        }

        @Override
        public boolean isMobile() {
            return mobile;
        }
    }
}
