package com.af.v4.system.common.resource.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Optional;

/**
 * 静态资源配置
 *
 * @author Mr.river
 */
@Configuration
@ConfigurationProperties(prefix = "resource")
public class ResourceConfig {

    @Value("${spring.application.name}")
    private String applicationName;

    // 资源根路径
    private String fileRootPath;

    // 扩展路径
    private String extraPaths;

    public String getFileRootPath() {
        return Optional.ofNullable(fileRootPath).filter(path -> !path.isEmpty()).orElseThrow(() -> new IllegalStateException("fileRootPath 未配置，请参考产品在 nacos 中 resource 层级下配置 fileRootPath"));
    }

    public void setFileRootPath(String fileRootPath) {
        this.fileRootPath = fileRootPath;
    }

    public String getExtraPaths() {
        return Optional.ofNullable(extraPaths)
                .filter(path -> !path.isEmpty())
                .orElseGet(() -> "/" + applicationName);
    }

    public String getExtraPathsWithoutLeadingSlash() {
        String extraPaths = getExtraPaths();
        if (extraPaths.startsWith("/")) {
            return extraPaths.substring(1);
        }
        return extraPaths;
    }

    public void setExtraPaths(String extraPaths) {
        this.extraPaths = extraPaths;
    }

    /**
     * 获取完整路径
     */
    public String getFullPath() {
        return String.join("", getFileRootPath(), getExtraPaths());
    }

}
