/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.resource.enums.ResourceType;
import com.af.v4.system.common.resource.mapper.AbstractResourceMapper;
import com.af.v4.system.common.resource.mapper.ModuleMapper;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.stream.Collectors;
import org.dom4j.Element;
import org.json.JSONObject;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Service;

@Component
public class PluginMapper
extends AbstractResourceMapper<PluginResource> {
    private static Map<String, Object> pluginMap;

    protected PluginMapper(ModuleMapper moduleMapper, ApplicationUtils applicationUtils, LiuLiConfigService liuLiConfigService) {
        super(moduleMapper, applicationUtils, liuLiConfigService);
    }

    public static Map<String, Object> getPluginMap() {
        return pluginMap;
    }

    @Override
    protected void loadMap() {
        super.loadMap();
        pluginMap = this.getAllMap().entrySet().stream().filter(object -> ((PluginResource)object.getValue()).getObj() != null).collect(Collectors.toMap(Map.Entry::getKey, object -> ((PluginResource)object.getValue()).getObj()));
    }

    @Override
    public ResourceType getResType() {
        return ResourceType.PLUGIN;
    }

    @Override
    public String getFileName() {
        return "plugins.xml";
    }

    @Override
    public String getFolderName() {
        return null;
    }

    @Override
    protected boolean isBinaryResource() {
        return true;
    }

    @Override
    public boolean isSupportCompile() {
        return false;
    }

    @Override
    protected Object getResPath(Element element, String moduleName, String parentModuleName) {
        return element.attribute("class").getValue();
    }

    @Override
    protected PluginResource buildResourceImpl(String moduleName, String key, Object path, JSONObject liuliValue, Map<String, Object> attrMap) {
        Object className = attrMap.get("class");
        return new PluginResource(this, moduleName, key, (Object)path.toString(), this.getObjByClassName(className.toString(), moduleName));
    }

    private Object getObjByClassName(String className, String moduleName) {
        try {
            Class<?> c = Class.forName(className);
            Object obj = this.isSpringBean(c) ? SpringUtils.getBean(c) : c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return obj;
        }
        catch (ClassNotFoundException | NoClassDefFoundError ex) {
            if (moduleName == null) {
                moduleName = "/";
            }
            LOGGER.warn("\u672a\u627e\u5230\u7c7b, \u6a21\u5757=" + moduleName + ", \u7c7b=" + ex.getMessage());
            return null;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private boolean isSpringBean(Class<?> c) {
        for (Annotation annotation : c.getAnnotations()) {
            if (annotation.annotationType() != Component.class && annotation.annotationType() != Service.class && annotation.annotationType() != Controller.class) continue;
            return true;
        }
        return false;
    }

    public static class PluginResource
    extends AbstractResourceMapper.CommonResource {
        private final Object obj;

        public PluginResource(AbstractResourceMapper<?> mapper, String moduleName, String key, Object path, Object obj) {
            super(mapper, moduleName, key, path, null);
            this.obj = obj;
        }

        public Object getObj() {
            return this.obj;
        }
    }
}

